﻿Imports System.IO
Public Class Form1
    Public path As String
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        path = Environment.GetEnvironmentVariable("ProgramFiles") & "\BedingterRuhezustand\"
        Call Einlesen()
        Call AdhocExclusionEinlesen()

    End Sub

    Private Sub Einlesen()
        ' Liest aus der Konfigurationsdatei BedingterRuhezustand.cfg die Leerlaufdauer, nach
        ' der in den Ruhezustand bzw. herunter gefahren werden soll, ein. Ermittelt aus der
        ' gleichen Datei, ob in den Ruhezustand oder herunter gefahren werden soll. Liest aus
        ' der Exclude.txt die regelmäßigen Ausnahmen ein. Trägt alle Werte in die GUI ein.

        Dim CfgFileStream As New FileStream(path & "BedingterRuhezustand.cfg", FileMode.Open)
        Dim ExcludeFileStream As New FileStream(path & "Exclude.txt", FileMode.Open)
        Dim CfgFile As New StreamReader(CfgFileStream)
        Dim ExcludeFile As New StreamReader(ExcludeFileStream)
        Dim zeile, minuten, wert As String
        Dim pos1, tag(7) As Integer

        ' Minuten und Shutdown-Modus einlesen
        Do Until CfgFile.Peek() = -1
            zeile = CfgFile.ReadLine()
            If LCase(Trim(zeile)).StartsWith("minuten") Then
                pos1 = zeile.IndexOf("=") + 1
                minuten = Trim(zeile.Substring(pos1))
                Me.TextBox1.Text = minuten
            End If
            If LCase(Trim(zeile)).StartsWith("herunterfahrenstattruhezustand") Then
                pos1 = zeile.IndexOf("=") + 1
                wert = Trim(zeile.Substring(pos1))
                Me.CheckBox1.Checked = wert
            End If
        Loop
        CfgFile.Close()

        ' Exclude.txt einlesen
        Do Until ExcludeFile.Peek() = -1
            zeile = ExcludeFile.ReadLine()
            If LCase(zeile).StartsWith("mo") Then
                tag(1) += 1
                pos1 = zeile.IndexOf("=") + 1
                If tag(1) = 1 Then Me.TextBox2.Text = zeile.Substring(pos1)
                If tag(1) = 2 Then Me.TextBox3.Text = zeile.Substring(pos1)
                If tag(1) = 3 Then Me.TextBox4.Text = zeile.Substring(pos1)
            End If
            If LCase(zeile).StartsWith("di") Then
                tag(2) += 1
                pos1 = zeile.IndexOf("=") + 1
                If tag(2) = 1 Then Me.TextBox5.Text = zeile.Substring(pos1)
                If tag(2) = 2 Then Me.TextBox6.Text = zeile.Substring(pos1)
                If tag(2) = 3 Then Me.TextBox7.Text = zeile.Substring(pos1)
            End If
            If LCase(zeile).StartsWith("mi") Then
                tag(3) += 1
                pos1 = zeile.IndexOf("=") + 1
                If tag(3) = 1 Then Me.TextBox8.Text = zeile.Substring(pos1)
                If tag(3) = 2 Then Me.TextBox9.Text = zeile.Substring(pos1)
                If tag(3) = 3 Then Me.TextBox10.Text = zeile.Substring(pos1)
            End If
            If LCase(zeile).StartsWith("do") Then
                tag(4) += 1
                pos1 = zeile.IndexOf("=") + 1
                If tag(4) = 1 Then Me.TextBox11.Text = zeile.Substring(pos1)
                If tag(4) = 2 Then Me.TextBox12.Text = zeile.Substring(pos1)
                If tag(4) = 3 Then Me.TextBox13.Text = zeile.Substring(pos1)
            End If
            If LCase(zeile).StartsWith("fr") Then
                tag(5) += 1
                pos1 = zeile.IndexOf("=") + 1
                If tag(5) = 1 Then Me.TextBox14.Text = zeile.Substring(pos1)
                If tag(5) = 2 Then Me.TextBox15.Text = zeile.Substring(pos1)
                If tag(5) = 3 Then Me.TextBox16.Text = zeile.Substring(pos1)
            End If
            If LCase(zeile).StartsWith("sa") Then
                tag(6) += 1
                pos1 = zeile.IndexOf("=") + 1
                If tag(6) = 1 Then Me.TextBox17.Text = zeile.Substring(pos1)
                If tag(6) = 2 Then Me.TextBox18.Text = zeile.Substring(pos1)
                If tag(6) = 3 Then Me.TextBox19.Text = zeile.Substring(pos1)
            End If
            If LCase(zeile).StartsWith("so") Then
                tag(7) += 1
                pos1 = zeile.IndexOf("=") + 1
                If tag(7) = 1 Then Me.TextBox20.Text = zeile.Substring(pos1)
                If tag(7) = 2 Then Me.TextBox21.Text = zeile.Substring(pos1)
                If tag(7) = 3 Then Me.TextBox22.Text = zeile.Substring(pos1)
            End If
        Loop
        ExcludeFile.Close()

    End Sub

    Sub AdhocExclusionEinlesen()
        ' Liest aus der Konfigurationsdatei AdhocExclusion.txt die aktuelle Adhoc-Ausnahme
        ' ein.

        Dim i, pos1 As Integer
        Dim zeile(1000) As String
        Dim AdhocFileStream As New FileStream(path & "AdhocExclusion.txt", FileMode.Open)
        Dim AdhocFile As New StreamReader(AdhocFileStream)
        i = 0
        Do Until AdhocFile.Peek() = -1
            zeile(i) = AdhocFile.ReadLine()
            If InStr(zeile(i), "AdhocExclusion") Then
                pos1 = InStr(zeile(i), "=")
                Me.Label27.Text = "(aktuelle Ausnahme: bis " & zeile(i).Substring(pos1) & ")"
            End If
            i += 1
        Loop
        AdhocFile.Close()
    End Sub
    Private Sub Speichern()
        ' Speichert alle Werte aus der GUI in die entsprechenden Dateien
        Dim CfgFileStream As New FileStream(path & "BedingterRuhezustand.cfg", FileMode.Open)
        Dim CfgFile As New StreamReader(CfgFileStream)
        Dim zeile(1000) As String
        Dim i, j, tag(7) As Integer
        ' Minuten einlesen
        i = 0
        Do Until CfgFile.Peek() = -1
            zeile(i) = CfgFile.ReadLine()
            i += 1
        Loop
        CfgFile.Close()
        Dim CfgFileStreamWrite As New FileStream(path & "BedingterRuhezustand.cfg", FileMode.Create)
        Dim CfgFileWrite As New StreamWriter(CfgFileStreamWrite)
        For j = 0 To i - 1
            If LCase(Trim(zeile(j))).StartsWith("minuten") Or LCase(Trim(zeile(j))).StartsWith("herunterfahrenstattruhezustand") Then
                If LCase(Trim(zeile(j))).StartsWith("minuten") Then CfgFileWrite.WriteLine("Minuten=" & Me.TextBox1.Text)
                If LCase(Trim(zeile(j))).StartsWith("herunterfahrenstattruhezustand") Then CfgFileWrite.WriteLine("HerunterfahrenStattRuhezustand=" & Me.CheckBox1.Checked)
            Else
                CfgFileWrite.WriteLine(zeile(j))
            End If
        Next
        CfgFileWrite.Close()

        Dim ExcludeFileStream As New FileStream(path & "Exclude.txt", FileMode.Open)
        Dim ExcludeFile As New StreamReader(ExcludeFileStream)

        ' Exclude.txt
        i = 0
        Do Until ExcludeFile.Peek() = -1
            zeile(i) = ExcludeFile.ReadLine()
            i += 1
        Loop
        ExcludeFile.Close()
        Dim ExcludeFileStreamWrite As New FileStream(path & "Exclude.txt", FileMode.Create)
        Dim ExcludeFileWrite As New StreamWriter(ExcludeFileStreamWrite)
        For j = 0 To i - 1
            If LCase(Trim(zeile(j))).StartsWith("#") Then
                ExcludeFileWrite.WriteLine(zeile(j))
            Else
            End If
        Next
        If Len(Me.TextBox2.Text) > 2 Then ExcludeFileWrite.WriteLine("Mo=" & Me.TextBox2.Text)
        If Len(Me.TextBox3.Text) > 2 Then ExcludeFileWrite.WriteLine("Mo=" & Me.TextBox3.Text)
        If Len(Me.TextBox4.Text) > 2 Then ExcludeFileWrite.WriteLine("Mo=" & Me.TextBox4.Text)
        If Len(Me.TextBox5.Text) > 2 Then ExcludeFileWrite.WriteLine("Di=" & Me.TextBox5.Text)
        If Len(Me.TextBox6.Text) > 2 Then ExcludeFileWrite.WriteLine("Di=" & Me.TextBox6.Text)
        If Len(Me.TextBox7.Text) > 2 Then ExcludeFileWrite.WriteLine("Di=" & Me.TextBox7.Text)
        If Len(Me.TextBox8.Text) > 2 Then ExcludeFileWrite.WriteLine("Mi=" & Me.TextBox8.Text)
        If Len(Me.TextBox9.Text) > 2 Then ExcludeFileWrite.WriteLine("Mi=" & Me.TextBox9.Text)
        If Len(Me.TextBox10.Text) > 2 Then ExcludeFileWrite.WriteLine("Mi=" & Me.TextBox10.Text)
        If Len(Me.TextBox11.Text) > 2 Then ExcludeFileWrite.WriteLine("Do=" & Me.TextBox11.Text)
        If Len(Me.TextBox12.Text) > 2 Then ExcludeFileWrite.WriteLine("Do=" & Me.TextBox12.Text)
        If Len(Me.TextBox13.Text) > 2 Then ExcludeFileWrite.WriteLine("Do=" & Me.TextBox13.Text)
        If Len(Me.TextBox14.Text) > 2 Then ExcludeFileWrite.WriteLine("Fr=" & Me.TextBox14.Text)
        If Len(Me.TextBox15.Text) > 2 Then ExcludeFileWrite.WriteLine("Fr=" & Me.TextBox15.Text)
        If Len(Me.TextBox16.Text) > 2 Then ExcludeFileWrite.WriteLine("Fr=" & Me.TextBox16.Text)
        If Len(Me.TextBox17.Text) > 2 Then ExcludeFileWrite.WriteLine("Sa=" & Me.TextBox17.Text)
        If Len(Me.TextBox18.Text) > 2 Then ExcludeFileWrite.WriteLine("Sa=" & Me.TextBox18.Text)
        If Len(Me.TextBox19.Text) > 2 Then ExcludeFileWrite.WriteLine("Sa=" & Me.TextBox19.Text)
        If Len(Me.TextBox20.Text) > 2 Then ExcludeFileWrite.WriteLine("So=" & Me.TextBox20.Text)
        If Len(Me.TextBox21.Text) > 2 Then ExcludeFileWrite.WriteLine("So=" & Me.TextBox21.Text)
        If Len(Me.TextBox22.Text) > 2 Then ExcludeFileWrite.WriteLine("So=" & Me.TextBox22.Text)
        ExcludeFileWrite.Close()

        ' Adhoc-Ausnahme
        If Me.CheckBox2.Checked = True Then
            Dim AdhocFileStream As New FileStream(path & "AdhocExclusion.txt", FileMode.Open)
            Dim AdhocFile As New StreamReader(AdhocFileStream)
            i = 0
            Do Until AdhocFile.Peek() = -1
                zeile(i) = AdhocFile.ReadLine()
                i += 1
            Loop
            AdhocFile.Close()
            Dim AdhocFileStreamWrite As New FileStream(path & "AdhocExclusion.txt", FileMode.Create)
            Dim AdhocFileWrite As New StreamWriter(AdhocFileStreamWrite)
            For j = 0 To i - 1
                If LCase(Trim(zeile(j))).StartsWith("#") Then
                    AdhocFileWrite.WriteLine(zeile(j))
                Else
                End If
            Next
            Dim jetzt As New DateTime
            jetzt = Date.Now.AddMinutes(Me.TextBox24.Text * 60)
            AdhocFileWrite.WriteLine("AdhocExclusion=" & jetzt)
            AdhocFileWrite.Close()
            Call AdhocExclusionEinlesen()
        End If
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        ' Button 'Ende' wurde angeklickt
        End
    End Sub

    Private Sub Label1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label1.Click

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        ' Button 'Speichern' wurde angeklickt
        If Val(Me.TextBox1.Text) < 3 Or Val(Me.TextBox1.Text) > 999 Then
            MsgBox("Leerlaufdauer muss größer 2 und kleiner 1000 sein.")
        Else
            Me.TextBox1.Text = Val(Me.TextBox1.Text)
            Call Speichern()
        End If
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        ' Button 'Logdatei' wurde angeklickt
        Dim procID As Integer
        procID = Shell("notepad.exe " & path & "BedingterRuhezustand.log", AppWinStyle.NormalFocus)
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        ' Button 'Mo - Fr wie Mo' links wurde angeklickt
        Me.TextBox5.Text = Me.TextBox2.Text
        Me.TextBox8.Text = Me.TextBox2.Text
        Me.TextBox11.Text = Me.TextBox2.Text
        Me.TextBox14.Text = Me.TextBox2.Text
    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        ' Button 'Mo - Fr wie Mo' Mitte wurde angeklickt
        Me.TextBox6.Text = Me.TextBox3.Text
        Me.TextBox9.Text = Me.TextBox3.Text
        Me.TextBox12.Text = Me.TextBox3.Text
        Me.TextBox15.Text = Me.TextBox3.Text
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        ' Button 'Mo - Fr wie Mo' rechts wurde angeklickt
        Me.TextBox7.Text = Me.TextBox4.Text
        Me.TextBox10.Text = Me.TextBox4.Text
        Me.TextBox13.Text = Me.TextBox4.Text
        Me.TextBox16.Text = Me.TextBox4.Text
    End Sub

    Private Sub BeendenToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BeendenToolStripMenuItem.Click
        ' Beenden über Menü wurde angeklickt
        End
    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
    End Sub

    Private Sub CheckBox2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox2.CheckedChanged
        ' Adhoc-Ausnahme-Häkchen wurde gesetzt
        If Me.CheckBox2.Checked = True Then
            If Me.TextBox24.Text = "" Then Me.TextBox24.Text = "2"
        End If
    End Sub

    Private Sub ÜberBedingterRuhezustandToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ÜberBedingterRuhezustandToolStripMenuItem.Click
        ' 'Über BedingterRuhezustand...' wurde angeklickt
        MsgBox("BedingterRuhezustand Version 1.1" & Chr(13) & Chr(13) & "von Robert Hohmann 10/2009")
    End Sub
End Class
